<?php

namespace Modules\Finance\Entities;

use Illuminate\Database\Eloquent\Model;

class Fnc_transaction extends Model 
{

    protected $table = 'fnc_transactions';
    public $timestamps = true;
    protected $fillable = array('id_eleve', 'id_type_paiement', 'id_enseignant', 'montant', 'reste', 'date', 'etat', 'annee_academique', 'nom_table_indexe');
    protected $visible = array('id_eleve', 'id_type_paiement', 'id_enseignant', 'montant', 'reste', 'date', 'etat', 'annee_academique', 'nom_table_indexe');

    public function eleve()
    {
        return $this->belongsTo('App\Eleve', 'id_eleve');
    }

    public function fnc_type_paiement()
    {
        return $this->belongsTo('Modules\Finance\Entities\Fnc_types_paiement', 'id_type_paiement');
    }

    public function enseignant()
    {
        return $this->belongsTo('App\Enseignant', 'id_enseignant');
    }

    public function administrateur()
    {
        return $this->belongsTo('App\Administrateur', 'id_enseignant');
    }

}